IF EXISTS (SELECT * FROM sys.objects
		  WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_NF_ENT_DANFE_PROVISORIO_BLOQUEIO_PENDENTE_EXEC_ALL]')
			 AND type IN ( N'P', N'PC') )
    DROP PROCEDURE [dbo].[P_EST_NF_ENT_DANFE_PROVISORIO_BLOQUEIO_PENDENTE_EXEC_ALL];
GO

GO
--EXEC P_EST_NF_ENT_DANFE_PROVISORIO_BLOQUEIO_PENDENTE_EXEC_ALL
CREATE PROCEDURE P_EST_NF_ENT_DANFE_PROVISORIO_BLOQUEIO_PENDENTE_EXEC_ALL
WITH ENCRYPTION
AS
    SET NOCOUNT ON;
   -- SET ANSI_WARNINGS OFF;
    DECLARE @CD_FILIAL INT;
	--Incluindo modelo do danfe quando nao existe
	UPDATE
		EST_NF_ENT_DANFE_PROVISORIO
	SET 
		MODELO = RIGHT(LEFT(NR_AUTORIZADOR,22),2)
	FROM
		EST_NF_ENT_DANFE_PROVISORIO INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_PENDENTE ON
		EST_NF_ENT_DANFE_PROVISORIO.CD_CTR = EST_NF_ENT_DANFE_PROVISORIO_PENDENTE.CD_CTR 
	WHERE
		(MODELO=0 or MODELO is null)
	--Fim
	
	--Deletando da pendencia que nao foi o modelo 55
	DELETE
		EST_NF_ENT_DANFE_PROVISORIO_PENDENTE
	FROM
		EST_NF_ENT_DANFE_PROVISORIO INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_PENDENTE ON
		EST_NF_ENT_DANFE_PROVISORIO.CD_CTR = EST_NF_ENT_DANFE_PROVISORIO_PENDENTE.CD_CTR 
	WHERE
		MODELO<>55 
	--Fim

	--Aplicar origem do produto
	--EXEC P_EST_PROD_ORIGEM

	--Aplicar comprador produto pendente grupo
	EXEC P_EST_COMPRADOR_GRUPO_APLICAR_EXEC_ALL
	
	--Restaurar danfe que por ventura for excluido
	EXEC P_EST_NF_ENT_DANFE_PROVISORIO_RESTORE 
    
	--Vincular pedido de compras com o comprador
	EXEC P_EST_PED_CP_IT_COMPRADOR_APLICAR
	
	--Vincular nota fiscal de entrada ao comprador 
	EXEC P_EST_NF_ENT_IT_COMPRADOR_APLICAR
	
    BEGIN TRY

		IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID('tempdb..##TMP_V_EST_NF_ENT_DANFE_PROVISORIO_REPOSICAO_PBM'))
		BEGIN
			DROP TABLE ##TMP_V_EST_NF_ENT_DANFE_PROVISORIO_REPOSICAO_PBM
		END

		SELECT CD_CTR
		INTO ##TMP_V_EST_NF_ENT_DANFE_PROVISORIO_REPOSICAO_PBM
		FROM V_EST_NF_ENT_DANFE_PROVISORIO_REPOSICAO_PBM
		WHERE PERC_ATEND = 100

		CREATE INDEX IX_TESTE_V_EST_NF_ENT_DANFE_PROVISORIO_REPOSICAO_PBM ON ##TMP_V_EST_NF_ENT_DANFE_PROVISORIO_REPOSICAO_PBM ( CD_CTR )

	   DECLARE FILIAIS CURSOR FAST_FORWARD FOR
		  SELECT
			 CD_FILIAL
		  FROM
			 PRC_FILIAL
		  WHERE
			 STS_FILIAL = 0;

	   OPEN FILIAIS;
	   FETCH NEXT FROM FILIAIS INTO @CD_FILIAL;

	   WHILE @@FETCH_STATUS = 0
		  BEGIN
			 PRINT '  Filial ' + CONVERT(VARCHAR(5), @CD_FILIAL) + ' (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';

			 EXEC P_EST_NF_ENT_DANFE_PROVISORIO_BLOQUEIO_PENDENTE @CD_FILIAL;
			 FETCH NEXT FROM FILIAIS INTO @CD_FILIAL ;
		  END ;

	   CLOSE FILIAIS ;
	   DEALLOCATE FILIAIS ;

		DROP TABLE ##TMP_V_EST_NF_ENT_DANFE_PROVISORIO_REPOSICAO_PBM

	    PRINT 'Liberando pagamento que possui vinculo com XML ou validado pelo DDA ' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
	   EXEC P_PG_CRED_LIB_PGTO_VINCULO_DANFE 1; 
    
	END TRY
    BEGIN CATCH

		CLOSE FILIAIS ;
		DEALLOCATE FILIAIS ;
		DECLARE @ErrorMessage VARCHAR(4000) = ERROR_MESSAGE();
		DECLARE @ErrorSeverity INT = ERROR_SEVERITY();
		DECLARE @ErrorState INT = ERROR_STATE();

		INSERT INTO ADM_ERRO ( numero ,severidade ,estado ,rotina ,linha ,mensagem ,dtErro )
			SELECT
				ERROR_NUMBER()	  AS numero
				,@ErrorSeverity	  AS severidade
				,@ErrorState		  AS estado
				,'P_EST_NF_ENT_DANFE_PROVISORIO_BLOQUEIO_PENDENTE_EXEC_ALL'	  AS rotina
				,ERROR_LINE()		  AS linha
				,@ErrorMessage	  AS mensagem
				,GETDATE()		  AS dtErro ;

	    RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);

    END CATCH;
    
    

